package gov.va.med.mhv.admin.ldap;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LdapQueryCondition {
	private static final String PAREN_OPEN = "(";
	private static final String PAREN_CLOSE = ")";
	private static final String AND = "&";

	private String operator;
	private List conditions;
	
	private LdapQueryCondition(int conditionCount) {
		this.conditions = new ArrayList(conditionCount);
	}

	private LdapQueryCondition() {
		this(4);
	}

	private LdapQueryCondition(String operator, String condition1, String condition2) {
		this(2);
		this.operator = operator;
		addCondition(condition1);
		addCondition(condition2);
	}

	public static LdapQueryCondition and(String condition1, String condition2) {
		return new LdapQueryCondition(AND, condition1, condition2);
	}

	public String toQueryString() {
		if(conditions.isEmpty())
			throw new IllegalStateException("No conditions specified.");
		
		StringBuffer buf = new StringBuffer(PAREN_OPEN).append(operator);
		
		for(Iterator i = conditions.iterator(); i.hasNext();) {
			String condition = (String)i.next();
			buf.append(PAREN_OPEN).append(condition).append(PAREN_CLOSE);
		}
		
		buf.append(PAREN_CLOSE);
		return buf.toString();
	}

	protected void addCondition(String condition) {
		if(condition == null)
			throw new NullPointerException();

		this.conditions.add(condition);
	}
}
